<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Registration extends CI_Controller {

	/**
	 * Registration Controller
	 */
	function __construct() {
		parent::__construct();
		session_set_cookie_params(0,'/registration',DIRECT_DOMAIN,TRUE,TRUE);
		session_start();
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);
		$this->load->helper('url');
		if(USE_CAC_AUTH !== 'TRUE' && USE_PIV_AUTH !== 'TRUE') { redirect('auth/logout'); }
	}
	function index() {
		//check if this CAC user has already submitted a request (also check if there is a cert, if not they should
		//not be on this page anyway)
		if(isset($_SERVER['HTTP_CERT'])) {
			$this->load->database();
			if(USE_CAC_AUTH === 'TRUE') { $cert_info = $this->get_cert_info(); }
			else if(USE_PIV_AUTH === 'TRUE') { $cert_info = $this->get_piv_cert_info(); }
			//make sure edipi or piv id can be grabbed from cert, or the request should not be allowed anyway
			if(isset($cert_info['edipi']) || isset($cert_info['piv_id'])) {
				$this->load->model('webmailmodel');
				//check to make sure the user doesn't have a deactivated account
				$deactivated = TRUE;
				if(isset($cert_info['edipi']) && !$this->webmailmodel->is_deactivated('CAC',$cert_info['edipi'])) { $deactivated = FALSE; }
				if(isset($cert_info['piv_id']) && !$this->webmailmodel->is_deactivated('PIV',$cert_info['piv_id'])) { $deactivated = FALSE; }
				if(!$deactivated) {
					//see if there are any unprocessed requests for this user
					if(isset($cert_info['edipi'])) {
						$request_check = $this->db->query('SELECT user_name FROM requests WHERE user_edipi='.$this->db->escape($cert_info['edipi']).' AND approved_flag = 0 AND denied_flag = 0 AND created_flag = 0');
					}
					else if(isset($cert_info['piv_id'])) {
						$request_check = $this->db->query('SELECT user_name FROM requests WHERE user_piv_id='.$this->db->escape($cert_info['piv_id']).' AND approved_flag = 0 AND denied_flag = 0 AND created_flag = 0');
					}
					if($request_check->num_rows() > 0) { redirect('registration/request_processing'); }
					else {
						//also check if user already exists and send them to the inbox if they do
						if(isset($cert_info['edipi'])) {
							$created_check = $this->db->query('SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_edipi=' . $this->db->escape($cert_info['edipi']));
						}
						else if(isset($cert_info['piv_id'])) {
							$created_check = $this->db->query('SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_piv_id='.$this->db->escape($cert_info['piv_id']));
						}
						if($created_check->num_rows() > 0) { redirect('inbox'); }
					}
					
					$data['title'] = PORTAL_TITLE_PREFIX . 'Registration';
		
					if(isset($_SERVER['HTTP_CERT'])) {
						if(USE_CAC_AUTH === 'TRUE') { $cert_info = $this->get_cert_info(); }
						else if(USE_PIV_AUTH === 'TRUE') { $cert_info = $this->get_piv_cert_info(); }
						//TO DO: add some code for capitalizing names like DeWerd correctly, 
						//this is a difficult problem so for now just avoiding it by correcting it when the admin approves the form
						if(isset($cert_info["first"])) { $data["first"] = ucfirst(strtolower($cert_info["first"])); }
						if(isset($cert_info["middle"])) { $data["middle"] = ucfirst(strtolower($cert_info["middle"])); }
						if(isset($cert_info["last"])) { $data["last"] = ucfirst(strtolower($cert_info["last"])); }
						if(isset($cert_info["mail"])) { $data["mail"] = $cert_info["mail"]; }
						if(isset($cert_info["first"]) && isset($cert_info["last"])) {
							$username = $this->determine_valid_username($data["first"],$data["last"]);
							if($username) { $data["username"] = $username; }
							else { /*TO DO: do something if a valid username couldn't be generated */ }
						}
						else { /*TO DO: do the same thing here if no username can be generated because no first/last name */ }
					}
					//otherwise no cert is loaded, redirect to logout TO DO: make another page other than logout to direct to
					else { redirect('auth/logout'); }
					
					//load theme info into view data
					$get_theme = $this->webmailmodel->get_user_theme_info();
					$data['get_theme'] = $get_theme;
					$this->load->view('registration/index',$data);
				}
				else {
					$data['title'] = PORTAL_TITLE_PREFIX . 'Account Deactivated';
					$data['message'] = 'The user account associated with the provided credentials has been deactivated. '
									 . 'Please contact an administrator directly for help.';
					//load theme info into view data
					$get_theme = $this->webmailmodel->get_user_theme_info();
					$data['get_theme'] = $get_theme;
					$this->load->view('system_message',$data);
				}
			}
			else { redirect('auth/logout'); }
		}
		else {
			redirect('auth/logout');
		}
	}
	function process_form() {
		if(isset($_SERVER['HTTP_CERT'])) {
			//gather user submitted inputs
			$organization = $this->input->post("organization",TRUE);
			$department = $this->input->post("department",TRUE);
			$telephone = $this->input->post("telephone",TRUE);
			$title = $this->input->post("title",TRUE);
			
			if(USE_CAC_AUTH === 'TRUE') { $cert_info = $this->get_cert_info(); }
			else if(USE_PIV_AUTH === 'TRUE') { $cert_info = $this->get_piv_cert_info(); }
			//TO DO: add some code for capitalizing names like DeWerd correctly, 
			//this is a difficult problem so for now just avoiding it by correcting it when the admin approves the form
			if(isset($cert_info["edipi"])) { $edipi = $cert_info["edipi"]; }
			if(isset($cert_info['piv_id'])) { $piv_id = $cert_info['piv_id']; }
			if(isset($cert_info["first"])) { $first = ucfirst(strtolower($cert_info["first"])); }
			if(isset($cert_info["middle"])) { $middle = ucfirst(strtolower($cert_info["middle"])); }
			if(isset($cert_info["last"])) { $last = ucfirst(strtolower($cert_info["last"])); }
			if(isset($cert_info["mail"])) { $mail = $cert_info["mail"]; }
			if(isset($cert_info["first"]) && isset($cert_info["last"])) {
				$username = $this->determine_valid_username($first,$last);
				if(!$username) {  /*TO DO: do something if a valid username couldn't be generated */ }
			}
			else { /*TO DO: do the same thing here if no username can be generated because no first/last name */ }
			
			$this->load->database();
			$request_made = $this->db->query("INSERT INTO requests (user_name,user_edipi,user_piv_id,request_date,first_name,middle_name,last_name,organization,department,telephone,mail,title,approved_flag,created_flag,denied_flag) VALUES (" . $this->db->escape($username) . "," . $this->db->escape($edipi) . ',' . $this->db->escape($piv_id) . ',' . $this->db->escape(date('U')) . "," . $this->db->escape($first) . "," . $this->db->escape($middle) . "," . $this->db->escape($last) . "," . $this->db->escape($organization) . "," . $this->db->escape($department) . "," . $this->db->escape($telephone) . "," . $this->db->escape($mail) . "," . $this->db->escape($title) . "," . $this->db->escape(FALSE) . "," . $this->db->escape(FALSE) . "," . $this->db->escape(FALSE) . ")");
			if($request_made) { redirect('registration'); }
			else {
				//load theme info into view data
				$this->load->model('webmailmodel');
				$get_theme = $this->webmailmodel->get_user_theme_info();
				$data['get_theme'] = $get_theme;
				$this->load->view("system_message",array("title" => PORTAL_TITLE_PREFIX . "Request Submission Error", "message" => "There was an error processing your request. Please contact a system administrator for help if this problem continues.")); 
			}
		}
		//otherwise no cert is loaded, redirect to logout
		else { redirect("auth/logout"); }
	}
	
	/* This function loads a system message stating an request has already been receieved.
	 */
	function request_processing() {
		//check if this CAC user has already submitted a request (also check if there is a cert, if not they should
		//not be on this page anyway)
		if(isset($_SERVER['HTTP_CERT'])) {
			$this->load->database();
			if(USE_CAC_AUTH === 'TRUE') { $cert_info = $this->get_cert_info(); }
			else if(USE_PIV_AUTH === 'TRUE') { $cert_info = $this->get_piv_cert_info(); }
			//make sure edipi can be grabbed from cert, or the request should not be allowed anyway
			if(isset($cert_info["edipi"])) {
				//see if there are any unprocessed requests for this user
				$request_check = $this->db->query("SELECT user_name FROM requests WHERE user_edipi=" . $this->db->escape($cert_info["edipi"]) . " AND approved_flag = 0 AND denied_flag = 0 AND created_flag = 0");
				if($request_check->num_rows() > 0) { /*stay here if they have a request processing */ }
				else {
					//also check if user already exists and send them to the inbox if they do
					$created_check = $this->db->query("SELECT user_name FROM users WHERE  user_deleted_flag=0 AND user_edipi=" . $cert_info["edipi"]);
					if($created_check->num_rows() > 0) { redirect("inbox"); }
				}
			}
			else if(isset($cert_info['piv_id'])) {
				//see if there are any unprocessed requests for this user
				$request_check = $this->db->query("SELECT user_name FROM requests WHERE user_piv_id=" . $this->db->escape($cert_info['piv_id']) . " AND approved_flag = 0 AND denied_flag = 0 AND created_flag = 0");
				if($request_check->num_rows() > 0) { /*stay here if they have a request processing */ }
				else {
					//also check if user already exists and send them to the inbox if they do
					$created_check = $this->db->query("SELECT user_name FROM users WHERE  user_deleted_flag=0 AND user_piv_id=" . $cert_info['piv_id']);
					if($created_check->num_rows() > 0) { redirect("inbox"); }
				}
			}
			else { redirect("auth/logout"); }
		}
		else {
			redirect("auth/logout");
		}
		
		$data["title"] = PORTAL_TITLE_PREFIX . "Processing Request";
		$data["message"] = "Your request has been submitted and is currently awaiting review by a system administrator.";
		//load theme info into view data
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		$this->load->view("system_message",$data);
	}
	
	/* This function attempts to determine a valid username for a user given a first and last name.
	 * If it fails to find a valid username given the requirements that it does not already exist in the users table
	 * or in any requests where the approved and denied flag have both not yet been set, it will return false.
	 */
	private function determine_valid_username($first,$last) {
		//sanitize username input to remove any non-alphanumeric characters
		$first = preg_replace("/[^A-Za-z0-9]/", '', $first);
		$last = preg_replace("/[^A-Za-z0-9]/", '', $last);
		//theoretically we could hit max username lengths for last names
		//this probably won't happen though because I think the CAC limits the characters in this case as well
		if((isset($first) && isset($last)) && (strlen($first) > 0 && strlen($last) > 0)) {
			$start = strtolower($first[0] . $last);
			if($this->username_exists($start)) {
				$i = 2;
				while($this->username_exists($start . $i) && $i < 999) {
					$i++;
				}
				if($i <= 999) { return $start . $i; }
				else { return FALSE; }
			}
			else { return $start; }
		}
		else { return FALSE; }
	}
	
	/* This function simply checks if a username exists in the database in created or request processing users. Checks everything, including deleted users.
	 * It returns TRUE if the username exists and FALSE if it does not.
	 */
	private function username_exists($username) {
		$this->load->database();
		$username_check = $this->db->query("SELECT users.user_name FROM users LEFT JOIN requests ON (requests.user_name = users.user_name) WHERE users.user_name=" . $this->db->escape($username) . " OR (requests.user_name=" . $this->db->escape($username) .  " AND requests.approved_flag = 0 AND requests.denied_flag = 0)");
		if($username_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function simply checks if an EDIPI exists in the database in created users. Checks everything, including deleted users.
	 * It returns TRUE if the EDIPI exists and FALSE if it does not.
	 */
	private function edipi_exists($edipi) {
		$this->load->database();
		$edipi_check = $this->db->query('SELECT user_edipi FROM users WHERE user_edipi=' . $this->db->escape($edipi));
		if($edipi_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function simply checks if a PIV ID exists in the database in created users. Checks everything, including deleted users.
	 * It returns TRUE if the PIV ID exists and FALSE if it does not.
	 */
	private function piv_exists($piv_id) {
		$this->load->database();
		$piv_check = $this->db->query('SELECT user_piv_id FROM users WHERE user_piv_id=' . $this->db->escape($piv_id));
		if($piv_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function extracts information from the SSL certificate provided to the server.
	 * It assumes that the certificate is stored in the $_SERVER['HTTP_CERT'] variable, that the CN for the cert
	 * contains at the very least the first and last name, and a unique identication number delimited by periods.
	 * These assumptions should be valid for all DoD Common Access Cards.
	 */
	private function get_cert_info() {
		$cert = $this->clean_cert_string($_SERVER['HTTP_CERT']);
		$parsed_cert = openssl_x509_parse($cert);
		$cn_arr = explode(".",$parsed_cert["subject"]["CN"]);
		$last = $cn_arr[0];
		$first = $cn_arr[1];
		if(count($cn_arr) == 4) {
			//check if its suffix or last name
			if(strtolower($cn_arr[2]) == 'jr' || strtolower($cn_arr[2]) == 'sr' || $this->is_roman_numeric($cn_arr[2])) {
				$suffix = $cn_arr[2];
				$middle = '';
			}
			else { 
				$middle = $cn_arr[2];
				$suffix = '';
			}
			$edipi = $cn_arr[3];
		}
		else if(count($cn_arr) == 5) {
			$middle = $cn_arr[2];
			$suffix = $cn_arr[3];
			$edipi = $cn_arr[4];
		}
		else { $middle = ""; $edipi = $cn_arr[2]; }

		if(isset($parsed_cert["extensions"]["subjectAltName"])) {
			$alt_name_arr = explode(",",$parsed_cert["extensions"]["subjectAltName"]);
			$email = "";
			foreach($alt_name_arr as $alt_name) {
				if(strpos($alt_name,"email") !== FALSE) { $email = str_replace("email:","",$alt_name); }
			}
		}
		else { $email = ""; }
		
		
		
		//return array("edipi" => $edipi, "mail" => $email, "first" => $first, "middle" => $middle, "last" => $last, 'suffix' => $suffix);
		$cert_info = compact('edipi', 'first', 'middle', 'last', 'suffix'); //compact won't trigger notices if a var hasn't been set
		$cert_info['mail'] = $email;
		return $cert_info;
	}
	
	/* This function extracts information from the SSL certificate provided to the server.
	 * It assumes that the certificate is stored in the $_SERVER['HTTP_CERT'] variable, that the CN for the cert
	 * contains at the very least the first and last name, and a unique identication number delimited by spaces.
	 * These assumptions should be valid for all VA PIV Cards.
	 */
	private function get_piv_cert_info() {
		$cert = $this->clean_cert_string($_SERVER['HTTP_CERT']);
		$parsed_cert = openssl_x509_parse($cert);
		$cn_arr = explode(' ',trim($parsed_cert['subject']['CN']));
		$first = $cn_arr[0];
		$middle = $suffix = '';
		if(count($cn_arr) === 4) {
			if(preg_match('/\(.*?\)/',$cn_arr[3]) === 0) { //if there is not something appended in parentheses after the piv id
				//check if its suffix or last name
				if(strtolower($cn_arr[2]) == 'jr' || strtolower($cn_arr[2]) == 'sr' || $this->is_roman_numeric($cn_arr[2])) {
					$suffix = $cn_arr[2];
					$last = $cn_arr[1];
				}
				else {
					$middle = $cn_arr[1];
					$last = $cn_arr[2];
					$suffix = '';
				}
				$piv_id = $cn_arr[3];
			}
			else {
				$last = $cn_arr[1];
				$piv_id = $cn_arr[2];
			}
		}
		else if(count($cn_arr) === 5) {
			if(preg_match('/(.*?)/',$cn_arr[4]) === 0) { //if there is not something appended in parentheses after the piv id
				$middle = $cn_arr[1];
				$last = $cn_arr[2];
				$suffix = $cn_arr[3];
				$piv_id = $cn_arr[4];
			}
			else {
				//check if its suffix or last name
				if(strtolower($cn_arr[2]) == 'jr' || strtolower($cn_arr[2]) == 'sr' || $this->is_roman_numeric($cn_arr[2])) {
					$suffix = $cn_arr[2];
					$last = $cn_arr[1];
				}
				else {
					$middle = $cn_arr[1];
					$last = $cn_arr[2];
					$suffix = '';
				}
				$piv_id = $cn_arr[3];
			}
		}
		else if(count($cn_arr) == 3) {
			$last = $cn_arr[1];
			$piv_id = $cn_arr[2];
		}
		
		if(isset($parsed_cert['extensions']['subjectAltName'])) {
			$alt_name_arr = explode(',',$parsed_cert['extensions']['subjectAltName']);
			$email = "";
			foreach($alt_name_arr as $alt_name) {
				if(strpos($alt_name,'email') !== FALSE) { $email = str_replace('email:','',$alt_name); }
			}
		}
		else { $email = ""; }
		
		$return_arr = array('piv_id' => $piv_id, 'mail' => $email, 'first' => $first, 'middle' => $middle, 'last' => $last, 'suffix' => $suffix);
		return $return_arr;
	}
	
	/* This function determines if a string is a valid roman numeral. This is used in parsing names from CAC certs.
	 */
	private function is_roman_numeric($str) {
		preg_match ('/^M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$/',$str,$matches);
		if(count($matches) > 0) { return TRUE; }
		return FALSE;
	}
	
	/* This function cleans up the certificate string provided by the server so that it can be parsed by OpenSSL.
	 */
	private function clean_cert_string($cert) {
		$output = preg_replace("/-----[A-Z]+\sCERTIFICATE-----/","",$cert);
		$output = preg_replace("!\s+!"," ",$output);
		$cert = str_replace(" ","\n",$output);
		$cert = "-----BEGIN CERTIFICATE-----\n".trim($cert)."\n-----END CERTIFICATE-----";
		return $cert;
	}
}

/* End of file registration.php */
/* Location: ./application/controllers/registration.php */
